<!DOCTYPE html>
<html lang="ja" dir="ltr">
  <head>
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>サインアップページ</title>
    <link rel="icon" type="image/x-icon" href="images/favicon.ico">
    <meta name="description" content="サインアップページ">
    <link rel="stylesheet" href="styles.css">
  </head>
  <body dir="ltr">
    <header class="header-background">
      <nav class="light-navbar navbar navbar-expand-lg transparent">
        <div class="layout-wrap container">
          <div class="full-width-element navbar-brand"> <a href="index.php" class="icon-text-alignment">
              <div class="right-margin-small"> <img loading="lazy" src="images/5ed920ae.png" class="icon-size-small" alt=""> </div> <span class="responsive-text hidden">旅友</span>
            </a> </div>
          <div class="navbar-collapse offcanvas offcanvas-nav offcanvas-start" id="offcanvas">
            <div class="toggle-header offcanvas-header"> <button type="button" class="icon-button" onclick="document.getElementById('offcanvas').classList.remove('show')"> <span class="visually-hidden">Close</span> <svg class="icon-size" xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg> </button> </div>
            <div class="column-layout offcanvas-body">
              <ul class="navbar-nav">
                <li class="nav-item"> <a class="nav-link" href="index.php">ホーム</a> </li>
                <li class="nav-item"> <a class="nav-link" href="index.php#about">私たちに関しては</a> </li>
                <li class="nav-item"> <a class="nav-link" href="blog/index.php">ブログ</a> </li>
                <li class="nav-item"> <a class="nav-link" href="index.php#contact">連絡先</a> </li>
              </ul>
            </div>
          </div>
          <div class="full-flex-auto navbar-other">
            <ul class="row-layout-auto navbar-nav">
              <li class="responsive-hide nav-item"> <button class="hamburger" onclick="document.getElementById('offcanvas').classList.add('show')"> <span></span> </button> </li>
            </ul>
          </div>
        </div>
      </nav>
    </header>
    <section class="light-green-background">
      <div class="spaced-content-center container">
        <div class="flexible-layout-row">
          <div class="content-width-control">
            <h1 class="dynamic-title-size">サインアップページ</h1>
            <div class="subtle-text-line"> 新しいアカウントを今すぐ作成し、さまざまなサービスを利用しましょう。名前、メールアドレス、パスワードを入力し、登録を完了してください。以後、サインインしてお気に入りの機能を探索できます。 </div>
          </div>
        </div>
      </div>
    </section>
    <section class="background-reset-white">
      <div class="section-padding-bottom-lg container">
        <div class="flexible-layout-row">
          <div class="centered-content-area">
            <div class="card">
              <div class="centered-content-padding card-body">
                <form class="left-aligned-text">
                  <div class="relative-block-spacing form-floating"> <input required="" type="text" class="standard-input-field form-control" placeholder="名前を入力してください"> <label class="input-label-style">名前を入力</label> </div>
                  <div class="relative-block-spacing form-floating"> <input required="" type="email" class="standard-input-field form-control" placeholder="メールアドレスを入力してください"> <label class="input-label-style">メールアドレスを入力</label> </div>
                  <div class="relative-block-spacing form-floating"> <input required="" type="password" class="standard-input-field form-control" placeholder="パスワードを入力してください"> <label class="input-label-style">パスワードを入力</label> </div>
                  <div class="relative-block-spacing form-floating"> <input required="" type="password" class="standard-input-field form-control" placeholder="パスワードを確認"> <label class="input-label-style">パスワードを確認</label> </div> <button type="submit" class="button-primary-style btn btn-primary">サインアップページ</button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="section-padding">
      <div class="container-box">
        <div class="home-intro-layout">
          <div class="minimal-padding"> </div>
          <ul class="links-layout">
            <li><a href="index.php" class="interactive-text">ホーム</a></li>
            <li><a href="index.php#about" class="interactive-text">私たちについて</a></li>
            <li><a href="blog/index.php" class="interactive-text">ブログ</a></li>
            <li><a href="index.php#contact" class="interactive-text">連絡先</a></li>
            <li><a href="privacy-policy.php" class="interactive-text">プライバシーポリシー</a></li>
          </ul>
        </div>
        <div class="footer-layout">
          <div class="footer-text-color">© 2025 旅友. すべての権利を保有します。</div>
          <div class="address-block"> <span>東京都千代田区丸の内1丁目1番1号 8F</span> <span class="separator-line hidden">|</span> <span>+81 (738) 1117-3815</span> </div>
        </div>
      </div>
    </section>
    <div id="privacy_popup" class="popup-container">
      <div class="header-text">プライバシーポリシーのお知らせ</div>
      <p class="content-paragraph"> このウェブサイトでは、お客様の体験を向上させるためにクッキーを使用しています。クッキーの利用方法について詳しくは、プライバシーポリシーをご覧ください。 <a class="link-decoration" href="privacy-policy.php">プライバシーポリシーを読む</a> </p>
      <div class="button-group"> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="accept-button-style"> 同意する </button> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="decline-button-style"> 拒否する </button> </div>
    </div>
  </body>
</html>
