<!DOCTYPE html>
<html lang="ja" dir="ltr">
  <head>
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>プライバシーポリシー</title>
    <link rel="icon" type="image/x-icon" href="images/favicon.ico">
    <meta name="description" content="旅友のプライバシーポリシーについての情報を提供しています。">
    <link rel="stylesheet" href="styles.css">
  </head>
  <body dir="ltr">
    <header class="header-background">
      <nav class="light-navbar navbar navbar-expand-lg transparent">
        <div class="layout-wrap container">
          <div class="full-width-element navbar-brand"> <a href="index.php" class="icon-text-alignment">
              <div class="right-margin-small"> <img loading="lazy" src="images/5ed920ae.png" class="icon-size-small" alt=""> </div> <span class="responsive-text hidden">旅友</span>
            </a> </div>
          <div class="navbar-collapse offcanvas offcanvas-nav offcanvas-start" id="offcanvas">
            <div class="toggle-header offcanvas-header"> <button type="button" class="icon-button" onclick="document.getElementById('offcanvas').classList.remove('show')"> <span class="visually-hidden">Close</span> <svg class="icon-size" xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg> </button> </div>
            <div class="column-layout offcanvas-body">
              <ul class="navbar-nav">
                <li class="nav-item"> <a class="nav-link" href="index.php">ホーム</a> </li>
                <li class="nav-item"> <a class="nav-link" href="index.php#about">私たちに関しては</a> </li>
                <li class="nav-item"> <a class="nav-link" href="blog/index.php">ブログ</a> </li>
                <li class="nav-item"> <a class="nav-link" href="index.php#contact">連絡先</a> </li>
              </ul>
            </div>
          </div>
          <div class="full-flex-auto navbar-other">
            <ul class="row-layout-auto navbar-nav">
              <li class="responsive-hide nav-item"> <button class="hamburger" onclick="document.getElementById('offcanvas').classList.add('show')"> <span></span> </button> </li>
            </ul>
          </div>
        </div>
      </nav>
    </header>
    <section class="secondary-bg-color">
      <div class="spacious-centered-section container">
        <div class="flexible-layout-row">
          <div class="responsive-content-box">
            <div class="small-margin-bottom post-header">
              <h1 class="scalable-heading"> プライバシーポリシー </h1>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="background-reset-white">
      <div class="section-padding-bottom-lg container">
        <div class="flexible-layout-row">
          <div class="responsive-width-centered">
            <div class="negative-margin-top-lg blog single">
              <div class="card">
                <div class="card-img-top"> <img loading="lazy" src="" class="constrained-height-cover" alt=""> </div>
                <div class="flexible-auto-panel card-body">
                  <article class="extra-margin-bottom post">
                    <div class="positioned-paragraph">
                      <p>旅友（以下「当社」）は、お客様の個人情報の保護を重要視しています。本プライバシーポリシーは、当社がどのように情報を収集し、使用し、保護するかについて説明します。</p>
                      <ol>
                        <li>
                          <p><strong>情報の収集</strong> 当社は、直接のやり取りやウェブサイトの使用を通じて、お客様から個人情報を収集することがあります。収集する情報には、お客様の名前、メールアドレスなどが含まれる場合がありますが、その他の情報は含みません。</p>
                        </li>
                        <li>
                          <p><strong>情報の使用</strong> 収集した情報は、お客様へのサービス提供、カスタマーサポート、およびウェブサイトの改善のために使用されます。お客様の同意なしに、他の目的で使用することはありません。</p>
                        </li>
                        <li>
                          <p><strong>情報の共有</strong> 当社は、お客様の情報を第三者と共有することはありません。ただし、法律に基づく要求がある場合はこの限りではありません。</p>
                        </li>
                        <li>
                          <p><strong>情報の保護</strong> 当社は、お客様の個人情報を保護するために、適切なセキュリティ対策を実施しています。</p>
                        </li>
                        <li>
                          <p><strong>クッキーの使用</strong> 当社のウェブサイトは、ユーザーエクスペリエンスを向上させるためにクッキーを使用しています。クッキーの使用については、ブラウザの設定から無効にすることができますが、ウェブサイトの一部の機能が利用できなくなる場合があります。</p>
                        </li>
                        <li>
                          <p><strong>プライバシーポリシーの変更</strong> 当社は、必要に応じて本プライバシーポリシーを更新することがあります。その際は、ウェブサイト上で通知いたします。</p>
                        </li>
                      </ol>
                      <p>お客様のプライバシーに関するご質問やご意見がございましたら、当社までご連絡ください。</p>
                    </div>
                  </article>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="section-padding">
      <div class="container-box">
        <div class="home-intro-layout">
          <div class="minimal-padding"> </div>
          <ul class="links-layout">
            <li><a href="index.php" class="interactive-text">ホーム</a></li>
            <li><a href="index.php#about" class="interactive-text">私たちについて</a></li>
            <li><a href="blog/index.php" class="interactive-text">ブログ</a></li>
            <li><a href="index.php#contact" class="interactive-text">連絡先</a></li>
            <li><a href="privacy-policy.php" class="interactive-text">プライバシーポリシー</a></li>
          </ul>
        </div>
        <div class="footer-layout">
          <div class="footer-text-color">© 2025 旅友. すべての権利を保有します。</div>
          <div class="address-block"> <span>東京都千代田区丸の内1丁目1番1号 8F</span> <span class="separator-line hidden">|</span> <span>+81 (738) 1117-3815</span> </div>
        </div>
      </div>
    </section>
    <div id="privacy_popup" class="popup-container">
      <div class="header-text">プライバシーポリシーのお知らせ</div>
      <p class="content-paragraph"> このウェブサイトでは、お客様の体験を向上させるためにクッキーを使用しています。クッキーの利用方法について詳しくは、プライバシーポリシーをご覧ください。 <a class="link-decoration" href="privacy-policy.php">プライバシーポリシーを読む</a> </p>
      <div class="button-group"> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="accept-button-style"> 同意する </button> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="decline-button-style"> 拒否する </button> </div>
    </div>
  </body>
</html>
