<!DOCTYPE html>
<html lang="ja" dir="ltr">
  <head>
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>旅友: 旅行の教育的視点</title>
    <link rel="icon" type="image/x-icon" href="images/favicon.ico">
    <meta name="description" content="旅友の公式ウェブサイトへようこそ。私たちは旅行を通じて歴史、文化、自然、哲学、そしてその影響を学ぶ場を提供します。日本の魅力を再発見し、旅行の新たな視点を探求してみませんか？">
    <link rel="stylesheet" href="styles.css">
  </head>
  <body dir="ltr">
    <nav class="header-bar-layout">
      <div class="page-container">
        <div class="responsive-flex-layout">
          <div class="mobile-nav-toggle"> <a href="index.php" class="icon-text-alignment">
              <div class="right-margin-small"> <img loading="lazy" src="images/5ed920ae.png" class="icon-size-small" alt=""> </div> <span class="responsive-text-style hidden">旅友</span>
            </a> <button onclick="const nav = document.getElementById('navbar'); nav.classList.toggle('hidden'); nav.classList.toggle('flex'); nav.classList.toggle('flex-col');" type="button" class="burger-menu-button" aria-controls="navbar-default" aria-expanded="false"> <span class="visually-hidden">Open main menu</span> <svg class="small-icon-size" aria-hidden="true" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
              </svg> </button> </div>
          <div class="expandable-nav hidden" id="navbar">
            <ul class="menu-flex-layout">
              <li> <a href="index.php" class="nav-item-link">ホーム</a> </li>
              <li> <a href="index.php#about" class="nav-item-link">私たちに関しては</a> </li>
              <li> <a href="blog/index.php" class="nav-item-link">ブログ</a> </li>
              <li> <a href="index.php#contact" class="nav-item-link">連絡先</a> </li>
            </ul>
            <div class="desktop-visible hidden"> <a href="index.php" class="icon-text-alignment">
                <div class="right-margin-small"> <img loading="lazy" src="images/5ed920ae.png" class="icon-size-small" alt=""> </div> <span class="responsive-text-style hidden">旅友</span>
              </a> </div>
            <div class="cta-buttons-container"> <a href="sign-in.php" class="login-button-style"> ログイン </a> <a href="sign-up.php" class="sign-up-button"> 登録 </a> </div>
          </div>
        </div>
      </div>
    </nav>
    <section class="hero-section-gradient">
      <div class="centralized-content-wrapper">
        <h1 class="main-heading"> 旅行の教育的視点 </h1>
        <p class="subheading-text"> 新しい視点で世界を探求する </p> <a href="sign-up.php" class="cta-button"> アカウントを作成 <svg class="small-left-margin" width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M7.5 15L11.0858 11.4142C11.7525 10.7475 12.0858 10.4142 12.0858 10C12.0858 9.58579 11.7525 9.25245 11.0858 8.58579L7.5 5" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
          </svg> </a>
        <div class="centered-content"> <img src="images/4dbd33b9.png" alt="" class="banner-image-style"> </div>
      </div>
    </section>
    <section class="section-spacing-wrapper" id="about">
      <div class="main-content-wrapper">
        <div class="grid-layout-section">
          <div class="flex-content-container">
            <div class="vertical-flex-container">
              <div class="flex-item-wrapper">
                <h6 class="muted-paragraph">日本の旅を教育的視点で見る</h6>
                <div class="text-block-wrapper">
                  <h2 class="highlighted-heading"> 旅友の使命</h2>
                  <p class="body-text-normal"> 「旅友」は、旅行を通して日本文化と自然の深い理解を目指しています。ここでは、商業的な要素を排除し、純粋に教育と文化交流に重きを置いています。旅の歴史、文化、自然、哲学、そしてそれらがもたらす影響を探求します。</p>
                </div>
              </div>
              <div class="nested-flex-container">
                <div class="feature-grid-layout">
                  <div class="stat-card">
                    <h4 class="card-heading">5K+</h4>
                    <p class="text-gray-500 text-base font-normal leading-relaxed"> 旅行がもたらした歴史的影響を探ります。 </p>
                  </div>
                  <div class="stat-card">
                    <h4 class="card-heading">3K+</h4>
                    <p class="text-gray-500 text-base font-normal leading-relaxed"> 旅を通じて文化を学ぶ方法を紹介。 </p>
                  </div>
                  <div class="stat-card">
                    <h4 class="card-heading">7K+</h4>
                    <p class="text-gray-500 text-base font-normal leading-relaxed"> 自然保護と旅行の関係性を考察。 </p>
                  </div>
                  <div class="stat-card">
                    <h4 class="card-heading">4K+</h4>
                    <p class="text-gray-500 text-base font-normal leading-relaxed"> 旅がもたらす内省と洞察を深める。 </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="media-container">
            <div class="image-card-lg"> <img class="responsive-image-style" src="images/713ac47d.png" alt="About"> </div>
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="responsive-padding-section container">
        <div class="flexible-layout-row">
          <div class="center-aligned-content">
            <h2 class="subheading-style">旅友についての体験談</h2>
            <h3 class="responsive-header-text"> お客様の声 </h3>
          </div>
        </div>
        <div>
          <div class="reset-margin-layout">
            <div class="responsive-item-container">
              <div class="card-neutral-background card">
                <div class="auto-flex-padding card-body">
                  <blockquote class="text-[0.85rem] leading-[1.7] font-medium pl-4 icon !mb-0 relative p-0 border-0 before:content-['\201d'] before:absolute before:top-[-1.5rem] before:left-[-0.9rem] before:text-[rgba(52,63,82,0.05)] before:text-[10rem] before:leading-none before:z-[1]">
                    <p>“旅行を通じて、歴史の奥深さに触れることができました。新しい視点から自分を見つめ直す良い機会でした。”</p>
                    <div class="aligned-flex-item">
                      <div class="reset-padding-left">
                        <h5 class="tight-spacing-title">鈴木 一郎</h5>
                        <p class="compact-text-style">歴史教師</p>
                      </div>
                    </div>
                  </blockquote>
                </div>
              </div>
            </div>
            <div class="responsive-item-container">
              <div class="card-soft-blue-bg card">
                <div class="auto-flex-padding card-body">
                  <blockquote class="text-[0.85rem] leading-[1.7] font-medium pl-4 icon !mb-0 relative p-0 border-0 before:content-['\201d'] before:absolute before:top-[-1.5rem] before:left-[-0.9rem] before:text-[rgba(52,63,82,0.05)] before:text-[10rem] before:leading-none before:z-[1]">
                    <p>“旅行と文化の融合を感じました。異文化への理解が深まり、自分の世界も広がりました。”</p>
                    <div class="aligned-flex-item">
                      <div class="reset-padding-left">
                        <h5 class="tight-spacing-title">田中 花子</h5>
                        <p class="compact-text-style">文化研究者</p>
                      </div>
                    </div>
                  </blockquote>
                </div>
              </div>
            </div>
            <div class="responsive-item-container">
              <div class="faint-gray-card-bg card">
                <div class="auto-flex-padding card-body">
                  <blockquote class="text-[0.85rem] leading-[1.7] font-medium pl-4 icon !mb-0 relative p-0 border-0 before:content-['\201d'] before:absolute before:top-[-1.5rem] before:left-[-0.9rem] before:text-[rgba(52,63,82,0.05)] before:text-[10rem] before:leading-none before:z-[1]">
                    <p>“自然の中で過ごす時間は、心を癒すものでした。旅行と自然の関係に感銘を受けました。”</p>
                    <div class="aligned-flex-item">
                      <div class="reset-padding-left">
                        <h5 class="tight-spacing-title">佐藤 健</h5>
                        <p class="compact-text-style">ネイチャーガイド</p>
                      </div>
                    </div>
                  </blockquote>
                </div>
              </div>
            </div>
            <div class="responsive-item-container">
              <div class="light-blue-border-radius card">
                <div class="auto-flex-padding card-body">
                  <blockquote class="text-[0.85rem] leading-[1.7] font-medium pl-4 icon !mb-0 relative p-0 border-0 before:content-['\201d'] before:absolute before:top-[-1.5rem] before:left-[-0.9rem] before:text-[rgba(52,63,82,0.05)] before:text-[10rem] before:leading-none before:z-[1]">
                    <p>“旅を通じて哲学的な思索を深めることができ、多くの気づきを得ました。新しい自分を発見できた旅でした。”</p>
                    <div class="aligned-flex-item">
                      <div class="reset-padding-left">
                        <h5 class="tight-spacing-title">高橋 直樹</h5>
                        <p class="compact-text-style">哲学者</p>
                      </div>
                    </div>
                  </blockquote>
                </div>
              </div>
            </div>
            <div class="responsive-item-container">
              <div class="soft-white-background card">
                <div class="auto-flex-padding card-body">
                  <blockquote class="text-[0.85rem] leading-[1.7] font-medium pl-4 icon !mb-0 relative p-0 border-0 before:content-['\201d'] before:absolute before:top-[-1.5rem] before:left-[-0.9rem] before:text-[rgba(52,63,82,0.05)] before:text-[10rem] before:leading-none before:z-[1]">
                    <p>“旅行の影響により、生活習慣や考え方が大きく変わりました。自分自身の成長を実感しています。”</p>
                    <div class="aligned-flex-item">
                      <div class="reset-padding-left">
                        <h5 class="tight-spacing-title">中村 愛</h5>
                        <p class="compact-text-style">生活コーチ</p>
                      </div>
                    </div>
                  </blockquote>
                </div>
              </div>
            </div>
            <div class="responsive-item-container">
              <div class="pale-green-card-box card">
                <div class="auto-flex-padding card-body">
                  <blockquote class="text-[0.85rem] leading-[1.7] font-medium pl-4 icon !mb-0 relative p-0 border-0 before:content-['\201d'] before:absolute before:top-[-1.5rem] before:left-[-0.9rem] before:text-[rgba(52,63,82,0.05)] before:text-[10rem] before:leading-none before:z-[1]">
                    <p>“旅行を通じて、さまざまな視点から物事を見ることの大切さを学びました。生活への新しい視点が得られました。”</p>
                    <div class="aligned-flex-item">
                      <div class="reset-padding-left">
                        <h5 class="tight-spacing-title">小林 英雄</h5>
                        <p class="compact-text-style">教育者</p>
                      </div>
                    </div>
                  </blockquote>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="large-padding-top-bottom">
      <div class="container-max-width">
        <div class="vertical-layout-center">
          <h2 class="large-title-text">旅の特徴</h2>
          <div class="vertical-content-spacing">
            <div class="responsive-grid-layout">
              <div class="interactive-card">
                <div class="stacked-content-box"> <a href="japan-travel-history.php" class="full-width-element"> <img class="centered-image-thumbnail" src="images/0e2e1d05.png" alt=""> </a>
                  <div class="compact-info-section">
                    <h5 class="subheading-text-format">日本の旅行の歴史</h5>
                    <p class="body-text-description">古来から現代までの歴史的な旅の変遷を探ります。文化や価値観の変化も紹介。</p>
                  </div>
                </div>
              </div>
              <div class="interactive-card">
                <div class="stacked-content-box"> <a href="cultural-travel-japan.php" class="full-width-element"> <img class="centered-image-thumbnail" src="images/f0ed002b.png" alt=""> </a>
                  <div class="compact-info-section">
                    <h5 class="subheading-text-format">文化的な旅</h5>
                    <p class="body-text-description">日本の多様な文化を通じた旅の魅力を紹介。その地域独自の伝統を体験します。</p>
                  </div>
                </div>
              </div>
              <div class="interactive-card">
                <div class="stacked-content-box"> <a href="nature-coexistence-travel.php" class="full-width-element"> <img class="centered-image-thumbnail" src="images/cd839757.png" alt=""> </a>
                  <div class="compact-info-section">
                    <h5 class="subheading-text-format">自然との共生</h5>
                    <p class="body-text-description">自然保護と旅行の関係について考え、持続可能な旅の在り方を学びます。</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="background-reset-white">
      <div class="responsive-padding-section container">
        <div class="project-gallery">
          <div>
            <div class="flexible-projects-container">
              <div class="project-tile-wide">
                <div class="rounded-overflow-hidden"><img loading="lazy" class="full-width-image" src="images/6b35370f.png" alt=""></div>
              </div>
              <div class="gallery-item-wide">
                <div class="project-info-align-center">
                  <div class="post-header">
                    <h2 class="responsive-title">日本の旅行の歴史</h2>
                    <p class="content-paragraph-style">旅行の歴史を探ることで、私たちの文化的ルーツと結びつきを理解できます。</p>
                  </div>
                </div>
              </div>
              <div class="project-tile-wide">
                <div class="rounded-overflow-hidden"> <img loading="lazy" class="full-width-image" src="images/f5cdf88b.png" alt=""></div>
              </div>
              <div class="project-tile-wide">
                <div class="rounded-overflow-hidden"> <img loading="lazy" class="full-width-image" src="images/1590f433.png" alt=""></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="section-spacing-y">
      <div class="container-max-width">
        <div class="flexible-layout">
          <div class="card-container">
            <div class="highlight-number"> 10K+ </div>
            <h4 class="subheader-text">歴史を学ぶ</h4>
            <p class="paragraph-text"> 旅行を通じ、歴史の舞台となった場所を訪れることで、過去から学ぶことができます。 </p>
          </div>
          <div class="card-container">
            <div class="highlight-number"> 20K+ </div>
            <h4 class="subheader-text">文化を感じる</h4>
            <p class="paragraph-text"> 異なる文化に触れ、多様性を尊重する心を育む絶好の機会です。 </p>
          </div>
          <div class="card-container">
            <div class="highlight-number"> 15K+ </div>
            <h4 class="subheader-text">自然と触れ合う</h4>
            <p class="paragraph-text"> 自然の中で過ごす時間は、私たちの心と体に癒しを与えます。 </p>
          </div>
        </div>
      </div>
    </section>
    <section class="large-padding-top-bottom">
      <div class="container-max-width">
        <h2 class="headline-style">ブログ：旅の教育的視点</h2>
        <div class="intro-text"> 旅の教育的視点から日本を探求し、旅行がもたらすさまざまな文化的、自然的、哲学的影響を紹介します。 </div>
        <div class="gallery-layout">
          <div class="responsive-item group">
            <div class="positioned-content-header"> <img src="images/b5232634.png" alt="" class="image-full-display">
              <div class="info-overlay"> <span class="date-style">January 10, 2024</span> <span class="category-label">文化と歴史</span> </div>
            </div>
            <div class="block-display"> <a href="blog/japanese-travel-through-history.php" class="link-style"> 歴史を通じて見る日本の旅 </a> </div>
          </div>
          <div class="responsive-item group">
            <div class="positioned-content-header"> <img src="images/3f6863d0.png" alt="" class="image-full-display">
              <div class="info-overlay"> <span class="date-style">February 14, 2024</span> <span class="category-label">自然と冒険</span> </div>
            </div>
            <div class="block-display"> <a href="blog/lessons-from-japanese-nature.php" class="link-style"> 自然が教える日本の旅 </a> </div>
          </div>
          <div class="responsive-item group">
            <div class="positioned-content-header"> <img src="images/79e42769.png" alt="" class="image-full-display">
              <div class="info-overlay"> <span class="date-style">March 5, 2024</span> <span class="category-label">哲学と思想</span> </div>
            </div>
            <div class="block-display"> <a href="blog/philosophy-impact-on-japanese-culture.php" class="link-style"> 旅の哲学：日本文化への影響 </a> </div>
          </div>
        </div> <a href="blog/index.php" class="button-primary"> すべてを見る </a>
      </div>
    </section>
    <section class="relative-container-with-padding">
      <div class="responsive-width-container">
        <div class="vertical-layout-center">
          <div class="main-text-container">
            <h2 class="heading-style-large">私たちの活動プロセス</h2>
            <p class="subheading-style-normal"> 私たちは、旅行を通じた学びの体験を提供し、参加者が新たな視野を広げることを支援します。文化、自然、歴史、哲学を探求し、多様な視点を得ることで、深い理解を促進します。 </p>
          </div>
          <div class="grid-container-three-cols">
            <div class="flexible-info-section">
              <div class="flex-space-between">
                <h4 class="medium-heading-text-style">旅行の歴史に触れる</h4>
                <h3 class="large-number-overlay">1</h3>
              </div>
              <p class="muted-paragraph">旅行の歴史を学び、文化や社会の発展における役割を理解します。古代の旅から現代までの変遷を探ります。</p>
            </div>
            <div class="flexible-info-section">
              <div class="flex-space-between">
                <h4 class="medium-heading-text-style">文化の多様性を探求</h4>
                <h3 class="large-number-overlay">2</h3>
              </div>
              <p class="muted-paragraph">各地域の文化を体験し、異なる価値観や伝統に触れることで多様性を理解します。交流や学びの機会を提供します。</p>
            </div>
            <div class="flexible-info-section">
              <div class="flex-space-between">
                <h4 class="medium-heading-text-style">自然とのつながりを感じる</h4>
                <h3 class="large-number-overlay">3</h3>
              </div>
              <p class="muted-paragraph">自然環境を体験し、環境保護の重要性を学びます。自然の美しさを知ることで、持続可能な未来を考えます。</p>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="large-padding-top-bottom">
      <div class="container-max-width">
        <div class="flex-column-centered-large-gap">
          <div class="compact-flex-column-center">
            <h2 class="centered-bold-title-large">よくある質問</h2>
            <p class="wide-paragraph-light-gray">ここでは、旅行の様々な側面についてのよくある質問にお答えします。</p>
          </div>
          <div class="aligned-column-layout">
            <div class="centered-inline-flex-row group">
              <div class="icon-button-transform"> <svg class="hover-text-color-transition" xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewbox="0 0 26 26" fill="none">
                  <path d="M9.20093 9.98274C9.20093 10.4246 9.5591 10.7827 10.0009 10.7827C10.4428 10.7827 10.8009 10.4246 10.8009 9.98274H9.20093ZM12.4736 15.5906C12.4736 16.0324 12.8317 16.3906 13.2736 16.3906C13.7154 16.3906 14.0736 16.0324 14.0736 15.5906H12.4736ZM12.9729 18.1611C12.5311 18.1611 12.1729 18.5193 12.1729 18.9611C12.1729 19.4029 12.5311 19.7611 12.9729 19.7611V18.1611ZM13.0271 19.7611C13.4689 19.7611 13.8271 19.4029 13.8271 18.9611C13.8271 18.5193 13.4689 18.1611 13.0271 18.1611V19.7611ZM21.95 13C21.95 17.9429 17.9429 21.95 13 21.95V23.55C18.8266 23.55 23.55 18.8266 23.55 13H21.95ZM13 21.95C8.05705 21.95 4.05 17.9429 4.05 13H2.45C2.45 18.8266 7.1734 23.55 13 23.55V21.95ZM4.05 13C4.05 8.05705 8.05705 4.05 13 4.05V2.45C7.1734 2.45 2.45 7.1734 2.45 13H4.05ZM13 4.05C17.9429 4.05 21.95 8.05705 21.95 13H23.55C23.55 7.1734 18.8266 2.45 13 2.45V4.05ZM10.8009 9.98274C10.8009 9.2238 11.0824 8.71073 11.4641 8.37768C11.8616 8.03083 12.4167 7.83892 13 7.83892C13.5833 7.83892 14.1384 8.03083 14.5359 8.37768C14.9176 8.71073 15.1991 9.2238 15.1991 9.98274H16.7991C16.7991 8.77913 16.3307 7.82029 15.5878 7.17207C14.8607 6.53765 13.9163 6.23892 13 6.23892C12.0838 6.23892 11.1393 6.53765 10.4122 7.17207C9.66925 7.82029 9.20093 8.77913 9.20093 9.98274H10.8009ZM15.1991 9.98274C15.1991 10.5383 15.0687 10.8763 14.9018 11.1339C14.7131 11.4252 14.4616 11.6483 14.0927 11.9899C13.7458 12.3112 13.3209 12.7182 12.9985 13.304C12.6692 13.9025 12.4736 14.6344 12.4736 15.5906H14.0736C14.0736 14.8651 14.2186 14.4056 14.4003 14.0754C14.589 13.7325 14.8454 13.4736 15.1799 13.1638C15.4924 12.8744 15.9223 12.5014 16.2446 12.0039C16.5888 11.4726 16.7991 10.8292 16.7991 9.98274H15.1991ZM12.9729 19.7611H13.0271V18.1611H12.9729V19.7611Z" fill="currentColor"></path>
                </svg> </div>
              <div class="hover-card-style">
                <h3 class="hover-heading-transform">旅行の歴史とは何ですか？</h3>
                <p class="hover-paragraph-transform">旅行の歴史は、古代の巡礼や探検から現代の観光旅行までの過程を指します。文化や社会の変遷に伴い、旅行のスタイルや目的も変わりました。この歴史は人々の視野を広げ、新しい文化との交流を促進する役割を果たしています。</p>
              </div>
            </div>
            <div class="centered-inline-flex-row group">
              <div class="hover-card-style">
                <h3 class="hover-heading-transform">旅行と文化の関係について教えてください。</h3>
                <p class="hover-paragraph-transform">旅行は異文化理解を深める重要な手段です。他国や異なる地域を訪れることで、現地の文化、伝統、生活様式に触れることができ、これにより自文化への新たな視点が得られます。</p>
              </div>
              <div class="icon-button-transform"> <svg class="hover-text-color-transition" xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewbox="0 0 26 26" fill="none">
                  <path d="M9.20093 9.98274C9.20093 10.4246 9.5591 10.7827 10.0009 10.7827C10.4428 10.7827 10.8009 10.4246 10.8009 9.98274H9.20093ZM12.4736 15.5906C12.4736 16.0324 12.8317 16.3906 13.2736 16.3906C13.7154 16.3906 14.0736 16.0324 14.0736 15.5906H12.4736ZM12.9729 18.1611C12.5311 18.1611 12.1729 18.5193 12.1729 18.9611C12.1729 19.4029 12.5311 19.7611 12.9729 19.7611V18.1611ZM13.0271 19.7611C13.4689 19.7611 13.8271 19.4029 13.8271 18.9611C13.8271 18.5193 13.4689 18.1611 13.0271 18.1611V19.7611ZM21.95 13C21.95 17.9429 17.9429 21.95 13 21.95V23.55C18.8266 23.55 23.55 18.8266 23.55 13H21.95ZM13 21.95C8.05705 21.95 4.05 17.9429 4.05 13H2.45C2.45 18.8266 7.1734 23.55 13 23.55V21.95ZM4.05 13C4.05 8.05705 8.05705 4.05 13 4.05V2.45C7.1734 2.45 2.45 7.1734 2.45 13H4.05ZM13 4.05C17.9429 4.05 21.95 8.05705 21.95 13H23.55C23.55 7.1734 18.8266 2.45 13 2.45V4.05ZM10.8009 9.98274C10.8009 9.2238 11.0824 8.71073 11.4641 8.37768C11.8616 8.03083 12.4167 7.83892 13 7.83892C13.5833 7.83892 14.1384 8.03083 14.5359 8.37768C14.9176 8.71073 15.1991 9.2238 15.1991 9.98274H16.7991C16.7991 8.77913 16.3307 7.82029 15.5878 7.17207C14.8607 6.53765 13.9163 6.23892 13 6.23892C12.0838 6.23892 11.1393 6.53765 10.4122 7.17207C9.66925 7.82029 9.20093 8.77913 9.20093 9.98274H10.8009ZM15.1991 9.98274C15.1991 10.5383 15.0687 10.8763 14.9018 11.1339C14.7131 11.4252 14.4616 11.6483 14.0927 11.9899C13.7458 12.3112 13.3209 12.7182 12.9985 13.304C12.6692 13.9025 12.4736 14.6344 12.4736 15.5906H14.0736C14.0736 14.8651 14.2186 14.4056 14.4003 14.0754C14.589 13.7325 14.8454 13.4736 15.1799 13.1638C15.4924 12.8744 15.9223 12.5014 16.2446 12.0039C16.5888 11.4726 16.7991 10.8292 16.7991 9.98274H15.1991ZM12.9729 19.7611H13.0271V18.1611H12.9729V19.7611Z" fill="currentColor"></path>
                </svg> </div>
            </div>
            <div class="centered-inline-flex-row group">
              <div class="icon-button-transform"> <svg class="hover-text-color-transition" xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewbox="0 0 26 26" fill="none">
                  <path d="M9.20093 9.98274C9.20093 10.4246 9.5591 10.7827 10.0009 10.7827C10.4428 10.7827 10.8009 10.4246 10.8009 9.98274H9.20093ZM12.4736 15.5906C12.4736 16.0324 12.8317 16.3906 13.2736 16.3906C13.7154 16.3906 14.0736 16.0324 14.0736 15.5906H12.4736ZM12.9729 18.1611C12.5311 18.1611 12.1729 18.5193 12.1729 18.9611C12.1729 19.4029 12.5311 19.7611 12.9729 19.7611V18.1611ZM13.0271 19.7611C13.4689 19.7611 13.8271 19.4029 13.8271 18.9611C13.8271 18.5193 13.4689 18.1611 13.0271 18.1611V19.7611ZM21.95 13C21.95 17.9429 17.9429 21.95 13 21.95V23.55C18.8266 23.55 23.55 18.8266 23.55 13H21.95ZM13 21.95C8.05705 21.95 4.05 17.9429 4.05 13H2.45C2.45 18.8266 7.1734 23.55 13 23.55V21.95ZM4.05 13C4.05 8.05705 8.05705 4.05 13 4.05V2.45C7.1734 2.45 2.45 7.1734 2.45 13H4.05ZM13 4.05C17.9429 4.05 21.95 8.05705 21.95 13H23.55C23.55 7.1734 18.8266 2.45 13 2.45V4.05ZM10.8009 9.98274C10.8009 9.2238 11.0824 8.71073 11.4641 8.37768C11.8616 8.03083 12.4167 7.83892 13 7.83892C13.5833 7.83892 14.1384 8.03083 14.5359 8.37768C14.9176 8.71073 15.1991 9.2238 15.1991 9.98274H16.7991C16.7991 8.77913 16.3307 7.82029 15.5878 7.17207C14.8607 6.53765 13.9163 6.23892 13 6.23892C12.0838 6.23892 11.1393 6.53765 10.4122 7.17207C9.66925 7.82029 9.20093 8.77913 9.20093 9.98274H10.8009ZM15.1991 9.98274C15.1991 10.5383 15.0687 10.8763 14.9018 11.1339C14.7131 11.4252 14.4616 11.6483 14.0927 11.9899C13.7458 12.3112 13.3209 12.7182 12.9985 13.304C12.6692 13.9025 12.4736 14.6344 12.4736 15.5906H14.0736C14.0736 14.8651 14.2186 14.4056 14.4003 14.0754C14.589 13.7325 14.8454 13.4736 15.1799 13.1638C15.4924 12.8744 15.9223 12.5014 16.2446 12.0039C16.5888 11.4726 16.7991 10.8292 16.7991 9.98274H15.1991ZM12.9729 19.7611H13.0271V18.1611H12.9729V19.7611Z" fill="currentColor"></path>
                </svg> </div>
              <div class="hover-card-style">
                <h3 class="hover-heading-transform">自然と旅行の関連性とは？</h3>
                <p class="hover-paragraph-transform">旅行は自然との接点を増やす機会でもあります。自然環境の中で過ごす時間は心身のリフレッシュにつながり、持続可能な旅行は環境保護意識を高めるのに役立ちます。</p>
              </div>
            </div>
            <div class="centered-inline-flex-row group">
              <div class="hover-card-style">
                <h3 class="hover-heading-transform">旅行の哲学とは何ですか？</h3>
                <p class="hover-paragraph-transform">旅行の哲学は、旅を通して自身の生き方や価値観を見直す過程を指します。新しい場所での体験は、普段の生活から離れ、自己洞察を深める機会を提供します。</p>
              </div>
              <div class="icon-button-transform"> <svg class="hover-text-color-transition" xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewbox="0 0 26 26" fill="none">
                  <path d="M9.20093 9.98274C9.20093 10.4246 9.5591 10.7827 10.0009 10.7827C10.4428 10.7827 10.8009 10.4246 10.8009 9.98274H9.20093ZM12.4736 15.5906C12.4736 16.0324 12.8317 16.3906 13.2736 16.3906C13.7154 16.3906 14.0736 16.0324 14.0736 15.5906H12.4736ZM12.9729 18.1611C12.5311 18.1611 12.1729 18.5193 12.1729 18.9611C12.1729 19.4029 12.5311 19.7611 12.9729 19.7611V18.1611ZM13.0271 19.7611C13.4689 19.7611 13.8271 19.4029 13.8271 18.9611C13.8271 18.5193 13.4689 18.1611 13.0271 18.1611V19.7611ZM21.95 13C21.95 17.9429 17.9429 21.95 13 21.95V23.55C18.8266 23.55 23.55 18.8266 23.55 13H21.95ZM13 21.95C8.05705 21.95 4.05 17.9429 4.05 13H2.45C2.45 18.8266 7.1734 23.55 13 23.55V21.95ZM4.05 13C4.05 8.05705 8.05705 4.05 13 4.05V2.45C7.1734 2.45 2.45 7.1734 2.45 13H4.05ZM13 4.05C17.9429 4.05 21.95 8.05705 21.95 13H23.55C23.55 7.1734 18.8266 2.45 13 2.45V4.05ZM10.8009 9.98274C10.8009 9.2238 11.0824 8.71073 11.4641 8.37768C11.8616 8.03083 12.4167 7.83892 13 7.83892C13.5833 7.83892 14.1384 8.03083 14.5359 8.37768C14.9176 8.71073 15.1991 9.2238 15.1991 9.98274H16.7991C16.7991 8.77913 16.3307 7.82029 15.5878 7.17207C14.8607 6.53765 13.9163 6.23892 13 6.23892C12.0838 6.23892 11.1393 6.53765 10.4122 7.17207C9.66925 7.82029 9.20093 8.77913 9.20093 9.98274H10.8009ZM15.1991 9.98274C15.1991 10.5383 15.0687 10.8763 14.9018 11.1339C14.7131 11.4252 14.4616 11.6483 14.0927 11.9899C13.7458 12.3112 13.3209 12.7182 12.9985 13.304C12.6692 13.9025 12.4736 14.6344 12.4736 15.5906H14.0736C14.0736 14.8651 14.2186 14.4056 14.4003 14.0754C14.589 13.7325 14.8454 13.4736 15.1799 13.1638C15.4924 12.8744 15.9223 12.5014 16.2446 12.0039C16.5888 11.4726 16.7991 10.8292 16.7991 9.98274H15.1991ZM12.9729 19.7611H13.0271V18.1611H12.9729V19.7611Z" fill="currentColor"></path>
                </svg> </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="spacing-layout-height" id="contact">
      <div class="container-max-width">
        <div class="responsive-two-column-grid">
          <div class="vertical-flex-gap">
            <div class="uniform-grid-gap"> <span class="highlight-base-text">お問い合わせ</span>
              <h2 class="hero-title-highlight">知識の旅へ</h2>
              <p class="muted-large-text">旅行の歴史や文化、自然とのつながりを探求する中で、私たちと交流しませんか？</p>
            </div>
            <div class="adaptive-height-image"> <img src="images/6a6a1c2f.png" alt="" class="auto-scaling-image"> </div>
          </div>
          <form method="post" onsubmit="this.querySelector('.alert').classList.remove('hidden'); return false;" class="form-container-design">
            <div class="alert-message-style alert hidden"> メッセージが正常に送信されました。折り返しご連絡いたします。 </div>
            <div class="main-form-row">
              <div class="form-item-spacing">
                <div class="caption-with-label"> <span class="form-label-style">お名前</span> </div> <input required="" type="text" class="styled-input-field" placeholder="お名前">
              </div>
            </div>
            <div class="main-form-row">
              <div class="form-item-spacing">
                <div class="caption-with-label"> <span class="form-label-style">メールアドレス</span> </div> <input required="" type="text" class="styled-input-field" placeholder="メールアドレス">
              </div>
            </div>
            <div class="main-form-row">
              <div class="form-item-spacing">
                <div class="caption-with-label"> <span class="form-label-style">電話番号</span> </div> <input required="" type="text" class="styled-input-field" placeholder="電話番号">
              </div>
            </div>
            <div class="main-form-row">
              <div class="form-item-spacing">
                <div class="caption-with-label"> <span class="form-label-style">メッセージ</span> </div> <input required="" type="text" class="styled-input-field" placeholder="メッセージ">
              </div>
            </div> <button class="primary-button-hover"> <span class="button-label-style">送信</span> </button>
          </form>
        </div>
      </div>
    </section>
    <section class="section-padding">
      <div class="container-box">
        <div class="home-intro-layout">
          <div class="minimal-padding"> </div>
          <ul class="links-layout">
            <li><a href="index.php" class="interactive-text">ホーム</a></li>
            <li><a href="index.php#about" class="interactive-text">私たちについて</a></li>
            <li><a href="blog/index.php" class="interactive-text">ブログ</a></li>
            <li><a href="index.php#contact" class="interactive-text">連絡先</a></li>
            <li><a href="privacy-policy.php" class="interactive-text">プライバシーポリシー</a></li>
          </ul>
        </div>
        <div class="footer-layout">
          <div class="footer-text-color">© 2025 旅友. すべての権利を保有します。</div>
          <div class="address-block"> <span>東京都千代田区丸の内1丁目1番1号 8F</span> <span class="separator-line hidden">|</span> <span>+81 (738) 1117-3815</span> </div>
        </div>
      </div>
    </section>
    <div id="privacy_popup" class="popup-container">
      <div class="header-text">プライバシーポリシーのお知らせ</div>
      <p class="content-paragraph"> このウェブサイトでは、お客様の体験を向上させるためにクッキーを使用しています。クッキーの利用方法について詳しくは、プライバシーポリシーをご覧ください。 <a class="link-decoration" href="privacy-policy.php">プライバシーポリシーを読む</a> </p>
      <div class="button-group"> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="accept-button-style"> 同意する </button> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="decline-button-style"> 拒否する </button> </div>
    </div>
  </body>
</html>
