<!DOCTYPE html>
<html lang="ja" dir="ltr">
  <head>
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>旅友</title>
    <link rel="icon" type="image/x-icon" href="../images/favicon.ico">
    <meta name="description" content="">
    <link rel="stylesheet" href="../styles.css">
  </head>
  <body dir="ltr">
    <header class="header-background">
      <nav class="light-navbar navbar navbar-expand-lg transparent">
        <div class="layout-wrap container">
          <div class="full-width-element navbar-brand"> <a href="../index.php" class="icon-text-alignment">
              <div class="right-margin-small"> <img loading="lazy" src="../images/5ed920ae.png" class="icon-size-small" alt=""> </div> <span class="responsive-text hidden">旅友</span>
            </a> </div>
          <div class="navbar-collapse offcanvas offcanvas-nav offcanvas-start" id="offcanvas">
            <div class="toggle-header offcanvas-header"> <button type="button" class="icon-button" onclick="document.getElementById('offcanvas').classList.remove('show')"> <span class="visually-hidden">Close</span> <svg class="icon-size" xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg> </button> </div>
            <div class="column-layout offcanvas-body">
              <ul class="navbar-nav">
                <li class="nav-item"> <a class="nav-link" href="../index.php">ホーム</a> </li>
                <li class="nav-item"> <a class="nav-link" href="../index.php#about">私たちに関しては</a> </li>
                <li class="nav-item"> <a class="nav-link" href="../blog/index.php">ブログ</a> </li>
                <li class="nav-item"> <a class="nav-link" href="../index.php#contact">連絡先</a> </li>
              </ul>
            </div>
          </div>
          <div class="full-flex-auto navbar-other">
            <ul class="row-layout-auto navbar-nav">
              <li class="responsive-hide nav-item"> <button class="hamburger" onclick="document.getElementById('offcanvas').classList.add('show')"> <span></span> </button> </li>
            </ul>
          </div>
        </div>
      </nav>
    </header>
    <section class="secondary-bg-color">
      <div class="content-padding-center container">
        <div class="flexible-layout-row">
          <div class="full-width-centered">
            <h1 class="dynamic-title">ブログ：旅の教育的視点</h1>
            <p class="paragraph-text-responsive">旅の教育的視点から日本を探求し、旅行がもたらすさまざまな文化的、自然的、哲学的影響を紹介します。</p>
          </div>
        </div>
      </div>
    </section>
    <div class="background-reset-white">
      <div class="section-padding-bottom-lg container">
        <div class="flexible-layout-row">
          <div class="responsive-width-centered">
            <div class="negative-margin-top-lg">
              <div class="flex-layout-gapless-lg">
                <article class="grid-item-layout post">
                  <div class="full-height-block card">
                    <div class="hover-overlay-effect card-img-top overlay group"> <a href="../blog/japanese-travel-through-history.php"> <img loading="lazy" class="smooth-zoom-effect" src="../images/b5232634.png" alt=""> </a> </div>
                    <div class="content-padding-adjusted card-body">
                      <div class="small-margin-bottom post-header">
                        <div class="tag-label"> <span>文化と歴史</span> </div>
                        <h2 class="heading-margin-adjust"> <a class="text-primary-color" href="../blog/japanese-travel-through-history.php">歴史を通じて見る日本の旅</a> </h2>
                      </div>
                      <div class="position-relative-overrides">
                        <p>日本の旅行の背景には、豊かな歴史があります。古代の巡礼から近代の観光まで、旅が日本の文化とどのように絡み合ってきたのかを探ります。</p>
                      </div>
                    </div>
                    <div class="button-padding-xl card-footer">
                      <ul class="small-text-list">
                        <li class="display-inline-box"><span>January 10, 2024</span></li>
                      </ul>
                    </div>
                  </div>
                </article>
                <article class="grid-item-layout post">
                  <div class="full-height-block card">
                    <div class="hover-overlay-effect card-img-top overlay group"> <a href="../blog/lessons-from-japanese-nature.php"> <img loading="lazy" class="smooth-zoom-effect" src="../images/3f6863d0.png" alt=""> </a> </div>
                    <div class="content-padding-adjusted card-body">
                      <div class="small-margin-bottom post-header">
                        <div class="tag-label"> <span>自然と冒険</span> </div>
                        <h2 class="heading-margin-adjust"> <a class="text-primary-color" href="../blog/lessons-from-japanese-nature.php">自然が教える日本の旅</a> </h2>
                      </div>
                      <div class="position-relative-overrides">
                        <p>日本の自然は旅行者に多くのことを教えてくれます。山、海、森の中での体験を通じて、自然が日本の旅行文化に与える影響を考察します。</p>
                      </div>
                    </div>
                    <div class="button-padding-xl card-footer">
                      <ul class="small-text-list">
                        <li class="display-inline-box"><span>February 14, 2024</span></li>
                      </ul>
                    </div>
                  </div>
                </article>
                <article class="grid-item-layout post">
                  <div class="full-height-block card">
                    <div class="hover-overlay-effect card-img-top overlay group"> <a href="../blog/philosophy-impact-on-japanese-culture.php"> <img loading="lazy" class="smooth-zoom-effect" src="../images/79e42769.png" alt=""> </a> </div>
                    <div class="content-padding-adjusted card-body">
                      <div class="small-margin-bottom post-header">
                        <div class="tag-label"> <span>哲学と思想</span> </div>
                        <h2 class="heading-margin-adjust"> <a class="text-primary-color" href="../blog/philosophy-impact-on-japanese-culture.php">旅の哲学：日本文化への影響</a> </h2>
                      </div>
                      <div class="position-relative-overrides">
                        <p>旅行が日本の哲学や生活にどのように影響を与えてきたかを深く探ります。旅を通じて得られる知恵とその哲学的な意味。</p>
                      </div>
                    </div>
                    <div class="button-padding-xl card-footer">
                      <ul class="small-text-list">
                        <li class="display-inline-box"><span>March 5, 2024</span></li>
                      </ul>
                    </div>
                  </div>
                </article>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <section class="section-padding">
      <div class="container-box">
        <div class="home-intro-layout">
          <div class="minimal-padding"> </div>
          <ul class="links-layout">
            <li><a href="../index.php" class="interactive-text">ホーム</a></li>
            <li><a href="../index.php#about" class="interactive-text">私たちについて</a></li>
            <li><a href="../blog/index.php" class="interactive-text">ブログ</a></li>
            <li><a href="../index.php#contact" class="interactive-text">連絡先</a></li>
            <li><a href="../privacy-policy.php" class="interactive-text">プライバシーポリシー</a></li>
          </ul>
        </div>
        <div class="footer-layout">
          <div class="footer-text-color">© 2025 旅友. すべての権利を保有します。</div>
          <div class="address-block"> <span>東京都千代田区丸の内1丁目1番1号 8F</span> <span class="separator-line hidden">|</span> <span>+81 (738) 1117-3815</span> </div>
        </div>
      </div>
    </section>
    <div id="privacy_popup" class="popup-container">
      <div class="header-text">プライバシーポリシーのお知らせ</div>
      <p class="content-paragraph"> このウェブサイトでは、お客様の体験を向上させるためにクッキーを使用しています。クッキーの利用方法について詳しくは、プライバシーポリシーをご覧ください。 <a class="link-decoration" href="../privacy-policy.php">プライバシーポリシーを読む</a> </p>
      <div class="button-group"> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="accept-button-style"> 同意する </button> <button onclick="document.getElementById('privacy_popup').style.display = 'none'" class="decline-button-style"> 拒否する </button> </div>
    </div>
  </body>
</html>
